<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine\Transport;

use Gls\GlsPoland\Soap\Engine\HttpBinding\SoapRequest;
use Gls\GlsPoland\Soap\Engine\HttpBinding\SoapResponse;
use Gls\GlsPoland\Soap\Engine\TransportInterface;

final class ExtSoapServerTransport implements TransportInterface
{
    /**
     * @var \SoapServer
     */
    private $server;

    public function __construct(\SoapServer $server)
    {
        $this->server = $server;
    }

    public function request(SoapRequest $request): SoapResponse
    {
        ob_start();
        $this->server->handle($request->getRequest());
        $responseBody = ob_get_clean();

        return new SoapResponse($responseBody);
    }
}
