<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\Engine;

use Gls\GlsPoland\Soap\Engine\Metadata\MetadataInterface;

final class LazyEngine implements EngineInterface
{
    /**
     * @var callable(): EngineInterface
     */
    private $factory;

    /**
     * @var EngineInterface|null
     */
    private $engine;

    /**
     * @param callable(): EngineInterface $factory
     */
    public function __construct(callable $factory)
    {
        $this->factory = $factory;
    }

    public function request(string $method, array $arguments)
    {
        return $this->getEngine()->request($method, $arguments);
    }

    public function getMetadata(): MetadataInterface
    {
        return $this->getEngine()->getMetadata();
    }

    private function getEngine(): EngineInterface
    {
        return $this->engine ?? ($this->engine = ($this->factory)());
    }
}
