<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Message;

class SendTrackingUrlEmailCommand
{
    private $orderCarrier;
    private $carrier;
    private $parcelNumber;

    public function __construct(\OrderCarrier $orderCarrier, \Carrier $carrier, string $parcelNumber)
    {
        $this->orderCarrier = $orderCarrier;
        $this->parcelNumber = $parcelNumber;
        $this->carrier = $carrier;
    }

    public function getOrderCarrier(): \OrderCarrier
    {
        return $this->orderCarrier;
    }

    public function getCarrier(): \Carrier
    {
        return $this->carrier;
    }

    public function getParcelNumber(): string
    {
        return $this->parcelNumber;
    }
}
