<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Installer;

use Gls\GlsPoland\PrestaShop\Message\ImportTranslationsCommand;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShop\PrestaShop\Core\CommandBus\CommandBusInterface;

final class TranslationInstaller implements InstallerInterface
{
    use TranslatorAwareTrait;

    private $bus;
    private $psVersion;

    public function __construct(CommandBusInterface $bus, string $psVersion)
    {
        $this->bus = $bus;
        $this->psVersion = $psVersion;
    }

    public function install(\Module $module): void
    {
        if (\Tools::version_compare($this->psVersion, '1.7.8', '>=')) {
            return;
        }

        $command = new ImportTranslationsCommand($module->getLocalPath() . 'translations/');

        try {
            $this->bus->handle($command);
        } catch (\Exception $e) {
            throw new InstallerException($this->getTranslator()->trans('Could not import module\'s translations.', [], 'Modules.Glspoland.Installer'), 0, $e);
        }
    }
}
