<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Admin\Legacy;

use Gls\GlsPoland\Controller\Admin\ConsignmentController;
use Gls\GlsPoland\PrestaShop\Hook\PrestaShopVersionAwareHookInterface;
use Gls\GlsPoland\PrestaShop\Hook\VersionRange;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShopBundle\Security\Voter\PageVoter;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Twig\Environment;

final class DisplayAdminOrdersListBefore implements PrestaShopVersionAwareHookInterface
{
    use TranslatorAwareTrait;

    public const HOOK_NAME = 'displayAdminOrdersListBefore';

    private $authorizationChecker;
    private $session;
    private $urlGenerator;
    private $twig;

    /**
     * @param Session $session
     */
    public function __construct(AuthorizationCheckerInterface $authorizationChecker, SessionInterface $session, UrlGeneratorInterface $urlGenerator, Environment $twig)
    {
        $this->authorizationChecker = $authorizationChecker;
        $this->session = $session;
        $this->urlGenerator = $urlGenerator;
        $this->twig = $twig;
    }

    public static function getVersionRange(): VersionRange
    {
        return new VersionRange(null, '1.7.7');
    }

    public function execute(array $parameters): string
    {
        if (!$this->authorizationChecker->isGranted(PageVoter::CREATE, ConsignmentController::TAB_NAME)) {
            return '';
        }

        return $this->twig->render('@Modules/glspoland/views/templates/hook/legacy/admin_orders_list_before.html.twig', [
            'session' => $this->session,
            'bulk_actions' => [
                [
                    'name' => $this->getTranslator()->trans('Create GLS consignments', [], 'Modules.Glspoland.Order'),
                    'url' => $this->urlGenerator->generate('admin_gls_poland_orders_legacy_bulk_create_consignments'),
                    'icon' => 'truck',
                ],
            ],
        ]);
    }
}
