<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Hook\Admin;

use Gls\GlsPoland\Controller\Admin\ConsignmentController;
use Gls\GlsPoland\PrestaShop\Hook\PrestaShopVersionAwareHookInterface;
use Gls\GlsPoland\PrestaShop\Hook\VersionRange;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShop\PrestaShop\Core\Grid\Action\Bulk\Type\SubmitBulkAction;
use PrestaShop\PrestaShop\Core\Grid\Definition\GridDefinitionInterface;
use PrestaShopBundle\Security\Voter\PageVoter;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

class ActionOrderGridDefinitionModifier implements PrestaShopVersionAwareHookInterface
{
    use TranslatorAwareTrait;

    public const HOOK_NAME = 'actionOrderGridDefinitionModifier';

    private $authorizationChecker;

    public function __construct(AuthorizationCheckerInterface $authorizationChecker)
    {
        $this->authorizationChecker = $authorizationChecker;
    }

    public static function getVersionRange(): VersionRange
    {
        return new VersionRange('1.7.7');
    }

    /**
     * @param array{definition: GridDefinitionInterface} $parameters
     */
    public function execute(array $parameters): void
    {
        if (!$this->authorizationChecker->isGranted(PageVoter::CREATE, ConsignmentController::TAB_NAME)) {
            return;
        }

        $parameters['definition']
            ->getBulkActions()
            ->add(
                (new SubmitBulkAction('gls_poland_create_consignment'))
                    ->setName($this->getTranslator()->trans('Create GLS consignments', [], 'Modules.Glspoland.Order'))
                    ->setOptions([
                        'submit_route' => 'admin_gls_poland_orders_bulk_create_consignments',
                    ])
            );
    }
}
