<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Asset;

use Gls\GlsPoland\Asset\AssetManagerInterface;
use Symfony\Component\Asset\Context\ContextInterface;

final class AdminAssetManager extends AbstractAssetManager
{
    private $context;
    private $controller;

    public function __construct(\Module $module, \Context $context, ?ContextInterface $requestContext = null)
    {
        parent::__construct($module, $requestContext);
        $this->context = $context;
    }

    public function registerJavaScript(string $path, array $options = []): AssetManagerInterface
    {
        $url = $this->getPackage()->getUrl($path);
        $this->getController()->addJS($url);

        return $this;
    }

    public function registerStyleSheet(string $path, array $options = []): AssetManagerInterface
    {
        $url = $this->getPackage()->getUrl($path);
        $this->getController()->addCSS($url, $options['media'] ?? 'all', null, false);

        return $this;
    }

    private function getController(): \AdminController
    {
        return $this->controller ?? ($this->controller = $this->context->controller);
    }
}
