<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Consignment;

use Gls\GlsPoland\Entity\Consignment;
use Gls\GlsPoland\EventDispatcher\Event;

final class ConsignmentEvent extends Event
{
    public const DELETED = 'gls_poland.consignment.deleted';

    private $consignment;

    public function __construct(Consignment $consignment)
    {
        $this->consignment = $consignment;
    }

    public function getConsignment(): Consignment
    {
        return $this->consignment;
    }
}
