<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Consignment;

use Gls\GlsPoland\Consignment\Builder\ConsignmentBuilderInterface;
use Gls\GlsPoland\Consignment\Builder\CourierConsignmentBuilder;
use Gls\GlsPoland\Consignment\Builder\ShopDeliveryConsignmentBuilder;
use Gls\GlsPoland\Consignment\Builder\ShopReturnConsignmentBuilder;
use Gls\GlsPoland\Message\CreateConsignmentCommand;

final class ConsignmentBuilderFactory implements ConsignmentBuilderFactoryInterface
{
    public function create(CreateConsignmentCommand $command): ConsignmentBuilderInterface
    {
        $serviceDetails = $command->getServiceDetails();

        if ($serviceDetails->isShopDelivery()) {
            return new ShopDeliveryConsignmentBuilder();
        }

        if ($serviceDetails->isShopReturn()) {
            return new ShopReturnConsignmentBuilder();
        }

        return new CourierConsignmentBuilder();
    }
}
