<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\Carrier\TimeDefiniteService;
use Gls\GlsPoland\Form\DataTransformer\TimeDefiniteServiceDataTransformer;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class TimeDefiniteServiceChoiceType extends AbstractType
{
    use TranslatorAwareTrait;

    public function getParent(): string
    {
        return ChoiceType::class;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addModelTransformer(new TimeDefiniteServiceDataTransformer());
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $translator = $this->getTranslator();

        $resolver
            ->setDefaults([
                'data_class' => null,
                'choices' => [
                    $translator->trans('Before 10:00 AM', [], 'Modules.Glspoland.Carrier') => TimeDefiniteService::DELIVERY_BEFORE_10,
                    $translator->trans('Before 12:00 AM', [], 'Modules.Glspoland.Carrier') => TimeDefiniteService::DELIVERY_BEFORE_12,
                ],
                'choice_attr' => function ($choice, string $key, string $value) {
                    return [
                        'data-service-id' => $value,
                    ];
                },
            ]);
    }
}
