<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use PrestaShopBundle\Form\Admin\Type\Material\MaterialChoiceTableType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class SearchableMaterialChoiceTableType extends AbstractType
{
    public function getParent(): string
    {
        return MaterialChoiceTableType::class;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'search_min_count' => 9,
            ])
            ->setAllowedTypes('search_min_count', 'int');
    }

    public function finishView(FormView $view, FormInterface $form, array $options): void
    {
        $class = $view->vars['attr']['class'] ?? '';
        $view->vars['attr']['class'] = $class . ' js-choice-table-container';
        $view->vars['searchable'] = count($view) >= $options['search_min_count'];
    }
}
