<?php

declare(strict_types=1);

namespace Gls\GlsPoland\DependencyInjection;

use Symfony\Contracts\Service\ServiceLocatorTrait;
use Symfony\Contracts\Service\ServiceProviderInterface;

final class ServiceLocator implements ServiceProviderInterface
{
    use ServiceLocatorTrait {
        ServiceLocatorTrait::__construct as private traitConstruct;
        ServiceLocatorTrait::getProvidedServices as private traitGetProvidedServices;
    }

    /**
     * @var array<string, string> types by service name
     */
    private $typeOverrides;

    /**
     * @param array<string, callable> $factories service factories by name
     * @param array<string, string> $providedTypes types by service name
     */
    public function __construct(array $factories, array $providedTypes = [])
    {
        $this->traitConstruct($factories);
        $this->typeOverrides = $providedTypes;
    }

    public function getProvidedServices(): array
    {
        return array_merge($this->traitGetProvidedServices(), $this->typeOverrides);
    }
}
