<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Consignment\Builder;

use Gls\GlsPoland\AdePlus\Common\Services;
use Gls\GlsPoland\AdePlus\Consignment\Consignment;
use Gls\GlsPoland\AdePlus\Consignment\SDSOptions;

final class ShopDeliveryConsignmentBuilder extends CourierConsignmentBuilder
{
    public function build(): Consignment
    {
        $options = $this->serviceDetails ? new SDSOptions($this->serviceDetails->getParcelShopId()) : null;

        return parent::build()->withShopDeliveryServiceOptions($options);
    }

    protected function buildServices(): Services
    {
        return (new Services())->withShopDelivery(true);
    }
}
