<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Api;

use Gls\GlsPoland\AdePlus\UserCredentialsInterface;
use Gls\GlsPoland\Validator\AdeUserCredentials;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Assert\GroupSequence({"InMemoryConfiguration", "Api"})
 */
final class InMemoryConfiguration implements ConfigurationInterface
{
    private $sandboxEnabled;

    /**
     * @Assert\Valid()
     *
     * @AdeUserCredentials(groups={"Api"})
     */
    private $prodCredentials;

    /**
     * @Assert\Valid()
     *
     * @AdeUserCredentials(sandbox=true, groups={"Api"})
     */
    private $testCredentials;

    public function __construct(?UserCredentialsInterface $prodCredentials = null, ?UserCredentialsInterface $testCredentials = null, bool $sandboxEnabled = false)
    {
        $this->prodCredentials = $prodCredentials;
        $this->testCredentials = $testCredentials;
        $this->sandboxEnabled = $sandboxEnabled;
    }

    public static function from(ConfigurationInterface $configuration): self
    {
        return new self(
            $configuration->getProdCredentials(),
            $configuration->getTestCredentials(),
            $configuration->isSandboxEnabled()
        );
    }

    public function isSandboxEnabled(): bool
    {
        return $this->sandboxEnabled;
    }

    public function setSandboxEnabled(bool $enabled): self
    {
        $this->sandboxEnabled = $enabled;

        return $this;
    }

    public function getProdCredentials(): ?UserCredentialsInterface
    {
        return $this->prodCredentials;
    }

    public function setProdCredentials(?UserCredentialsInterface $credentials): self
    {
        $this->prodCredentials = $credentials;

        return $this;
    }

    public function getTestCredentials(): ?UserCredentialsInterface
    {
        return $this->testCredentials;
    }

    public function setTestCredentials(?UserCredentialsInterface $credentials): self
    {
        $this->testCredentials = $credentials;

        return $this;
    }
}
