<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Services;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class MaxCODAmount implements ResultInterface, \JsonSerializable
{
    /**
     * @var float
     */
    private $max_cod;

    public function getAmountPln(): float
    {
        return $this->max_cod;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
