<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Services;

use Gls\GlsPoland\AdePlus\Client as AdePlusClient;
use Gls\GlsPoland\AdePlus\Common\Services;

final class Client implements ClientInterface
{
    private $client;

    public function __construct(AdePlusClient $client)
    {
        $this->client = $client;
    }

    public function getMaxParcelWeights(): MaxParcelWeights
    {
        $params = new GetMaxParcelWeights();

        return $this->client->servicesGetMaxParcelWeights($params);
    }

    public function getMaxCashOnDeliveryAmount(): float
    {
        $params = new GetMaxCOD();

        return $this->client->servicesGetMaxCOD($params)->getAmountPln();
    }

    public function getAllowedServices(): Services
    {
        $params = new GetAllowed();

        return $this->client->servicesGetAllowed($params)->getServices();
    }

    public function getGuaranteedServices(string $zipCode): Services
    {
        $params = new GetGuaranteed($zipCode);

        return $this->client->servicesGetGuaranteed($params)->getServices();
    }

    public function getShopDeliveryAvailableCountries(): array
    {
        $params = new GetCountriesSDS();

        return $this->client->servicesGetCountriesSDS($params)->getItems();
    }
}
