<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\SenderAddress;

use Gls\GlsPoland\Soap\Client\Type\ResultInterface;

final class SenderAddressStatus implements ResultInterface, \JsonSerializable
{
    public const ONLY_COMPANY = 0;
    public const ONLY_PREDEFINED = 1;
    public const FROM_DICTIONARY = 2;
    public const ANY = 3;

    public function __construct(int $status)
    {
        $this->status = $status;
    }

    /**
     * @var int
     */
    private $status;

    public function getValue(): int
    {
        return $this->status;
    }

    public function jsonSerialize(): array
    {
        return [
            'status' => $this->status,
        ];
    }
}
