<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Printout;

final class PickupReceiptPrintMode implements PrintModeInterface, \Stringable
{
    public const WITH_BARCODES = 'with_barcodes';
    public const CONDENSED = 'condensed';
    public const CONDENSED_WITH_DESCRIPTION = 'condensed_description_of_pickup';

    public const PRINT_MODES = [
        self::WITH_BARCODES,
        self::CONDENSED,
        self::CONDENSED_WITH_DESCRIPTION,
    ];

    private $mode;

    private function __construct(string $printMode)
    {
        $this->mode = $printMode;
    }

    public static function from(string $printMode): self
    {
        if (!in_array($printMode, self::PRINT_MODES, true)) {
            throw new \InvalidArgumentException(sprintf('Unrecognized pickup receipt type "%s".', $printMode));
        }

        return new self($printMode);
    }

    public static function tryFrom($value): ?self
    {
        if (!in_array($value, self::PRINT_MODES, true)) {
            return null;
        }

        return new self($value);
    }

    public function __toString(): string
    {
        return $this->mode;
    }

    public function getContentType(): string
    {
        return 'application/pdf';
    }

    public function getFileExtension(): string
    {
        return 'pdf';
    }
}
