<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Fault;

use Gls\GlsPoland\AdePlus\Authorization\Fault\IncorrectCredentialsFault;
use Gls\GlsPoland\AdePlus\Authorization\Fault\SessionExpiredFault;
use Gls\GlsPoland\AdePlus\Authorization\Fault\SessionNotFoundFault;
use Gls\GlsPoland\AdePlus\ParcelShop\Fault\ParcelShopNotFoundFault;
use Gls\GlsPoland\AdePlus\PreparingBox\Fault\IncorrectServiceCombinationFault;
use Gls\GlsPoland\Soap\Client\Exception\SoapFault;

final class FaultConverter implements FaultConverterInterface
{
    public function convert(SoapFault $exception): SoapFault
    {
        if ($exception instanceof AdePlusFault) {
            return $exception;
        }

        switch ($exception->getFaultCode()) {
            case IncorrectCredentialsFault::CODE:
                return IncorrectCredentialsFault::fromParent($exception);
            case SessionExpiredFault::CODE:
                return SessionExpiredFault::fromParent($exception);
            case SessionNotFoundFault::CODE:
                return SessionNotFoundFault::fromParent($exception);
            case ParcelShopNotFoundFault::CODE:
                return ParcelShopNotFoundFault::fromParent($exception);
            case IncorrectServiceCombinationFault::CODE:
                return IncorrectServiceCombinationFault::fromParent($exception);
            default:
                return AdePlusFault::fromParent($exception);
        }
    }
}
