<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus;

use Gls\GlsPoland\AdePlus\Consignment\Consignment;
use Gls\GlsPoland\AdePlus\Printout\Labels;
use Gls\GlsPoland\AdePlus\Printout\LabelsCollection;
use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;

interface ConsignmentsApiClientInterface
{
    public function isSandbox(): bool;

    public function getConsignment(int $id): Consignment;

    public function getLabels(int $consignmentId, LabelsPrintMode $printMode): Labels;

    public function getSeparateLabels(int $consignmentId, LabelsPrintMode $printMode): LabelsCollection;
}
